<?php

namespace App\Http\Controllers;

use App\Models\Ecommerce\Product;
use App\Models\Ecommerce\ProductType;
use App\Models\ProductCategory;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ProductCategoryController extends Controller
{
    public function index(Request $request)
    {
        $data['collection'] = ProductCategory::latest()->get();
        return view('category.index')->with($data);
    }

    public function create()
    {
        return view('category.create');
    }

    public function store(Request $request)
    {
        $this->inputValidation($request);
        try {
            $data = $request->all();
            $image = $request->file('image');
            $banner = $request->file('banner');
            if (!empty($image)) {
                $data['image'] = $this->fileUploader($image, 'images/product_category', 140, 140);
            }
            if (!empty($banner)) {
                $data['banner'] = $this->fileUploader($banner, 'images/product_category', 1350, 250);
            }
            $data['slug'] = Str::slug($request->title);
            ProductCategory::create($data);
            Toastr::success('Added successfully!', '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
            return redirect()->route('categories.index');
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        $category = ProductCategory::findOrFail($id);
        return view('category.edit', compact('category'));
    }

    public function update(Request $request, $id)
    {
        $this->inputValidation($request, $id);
        try {
            $product_type = ProductCategory::findOrFail($id);
            $data = $request->all();
            $image = $request->file('image');
            $banner = $request->file('banner');

            if (!empty($image)) {
                $data['image'] = $this->fileUploader($image, 'images/product_category', 135, 140,$product_type->image);
            } else {
                $data['image'] = $product_type->image;
            }
            // Banner image
            if (!empty($banner)) {
                $data['banner'] = $this->fileUploader($banner, 'images/product_category', 1350, 250,$product_type->banner);
            } else {
                $data['banner'] = $product_type->banner;
            }

            $data['slug'] = Str::slug($request->title);
            $product_type->update($data);
            Toastr::success('Product type been updated successfully!', '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
            return redirect()->route('categories.index');
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
            return redirect()->back();
        }
    }

    public function delete($id)
    {
        try {
            $category = ProductCategory::findOrFail($id);
            $res = $category->delete();
            if ($res){
                $this->deleteFile($category->image);
                $this->deleteFile($category->banner);
                Toastr::success('Product type been deleted successfully!', '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
                return redirect()->route('categories.index');
            }
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
            return redirect()->back();
        }
    }

    protected function inputValidation($request, $id = null)
    {
        $request->validate([
            'title' => 'required',
            'status' => 'required',
            'sorting' => 'required',
            'type' => 'required',
        ]);
    }
}
