<?php

namespace App\Http\Controllers;

use App\Models\Unit;
use Illuminate\Http\Request;

class UnitController extends Controller
{
    public function index(Request $request)
    {
        $collection = Unit::latest()->paginate(10);
        return view('unit.list', compact('collection'));
    }

    public function create()
    {
        return view('unit.add');
    }

    public function store(Request $request)
    {
        $request->validate([
           'name' => 'required|unique:units,name'
        ]);
        try {
            $unit = new Unit();
            $unit->name = $request->name;
            $unit->save();
            successAlert('Unit successfully created');
            return redirect()->route('unit.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        $unit = Unit::find($id);
        return view('unit.edit', compact('unit'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|unique:units,name,'.$id.',id'
        ]);
        try {
            $unit = Unit::find($id);
            $unit->name = $request->name;
            $unit->save();
            successAlert('Unit successfully Updated');
            return redirect()->route('unit.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }


    public function delete($id)
    {
        try {
            $unit = Unit::find($id);
            $unit->delete();
            successAlert('Unit successfully deleted');
            return redirect()->route('unit.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }
}
