<?php


namespace App\Models;


use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use Modules\MultiStore\App\Models\Store;

class BaseModel extends Model
{

    protected static function booted()
    {
        static::addGlobalScope('store_id', function (Builder $builder) {
            $storeId = request()->attributes->get('store_id');
            if ($storeId){
                if (isModuleActive('MultiStore')){
                    $builder->where('store_id', $storeId);
                }
            }
        });
    }


    protected static function boot()
    {
        parent::boot();

        static::creating(function ($store) {
            if (isModuleActive('MultiStore')){
                if (!$store->store_id) {
                    $store->store_id = Request::get('store_id');
                }
            }
        });
    }

    public function store()
    {
        if (isModuleActive('MultiStore')) {
            return $this->belongsTo(Store::class, 'store_id', 'id');
        }
        return null;
    }
}