<?php


namespace App\Service;


use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class CustomerDueExcelExport implements FromView
{
    protected $customers;
    protected $total_previous_payable;
    protected $total_invoice_payable;

    public function __construct($customers, $total_previous_payable, $total_invoice_payable)
    {
        $this->customers = $customers;
        $this->total_previous_payable = $total_previous_payable;
        $this->total_invoice_payable = $total_previous_payable;
    }

    public function view(): View
    {
        return view('exports.customer_due_report', [
            'reports' => $this->customers,
            'total_previous_payable' => $this->total_previous_payable,
            'total_invoice_payable' => $this->total_invoice_payable,
        ]);
    }
}