@extends('layouts.backend')
@section('title', "Income Statement")
@section('content')
<x-container title="Income Statement">
    <div class="text-end">
        <a href="javascript:" id="window-printer" onclick="return(window.print())" class="btn btn-sm btn-success mb-2">
            <i class="fa fa-print"></i>
            {{ translate('common.Print') }}
        </a>
    </div>
    <div class="table-responsive pt-0">
        <table class="table">
            <thead>
            <tr>
                <th>{{ translate('common.Account Name') }}</th>
                <th>{{ translate('common.Balance') }}</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <th><h4>{{ translate('common.Revenue') }}</h4></th>
            </tr>
            @foreach($incomeStatement['revenues'] as $balance)
                <tr>
                    <td class="name">{{ $balance->account_name }}</td>
                    <td>{{  priceFormat($balance->balance) }}</td>
                </tr>
            @endforeach
            <tr>
                <td><h5>{{ translate('common.Total') }}</h5></td>
                <td><h5 class="text-decoration-underline">{{  priceFormat($incomeStatement['totalRevenue']) }}</h5></td>
            </tr>
            <tr>
                <th><h4>{{ translate('common.Expense') }}</h4></th>
            </tr>
            @foreach($incomeStatement['expenses'] as $balance)
                <tr>
                    <td class="name">{{ $balance->account_name }}</td>
                    <td>{{  priceFormat($balance->balance) }}</td>
                </tr>
            @endforeach
            <tr>
                <td><h5>{{ translate('common.Total') }}</h5></td>
                <td><h5 class="text-decoration-underline">{{  priceFormat($incomeStatement['totalExpense']) }}</h5></td>
            </tr>
            <tr>
                <td class="name"><h4>{{ translate('common.net Income') }}</h4></td>
                <td><h4>{{ priceFormat($incomeStatement['netIncome']) }}</h4></td>
            </tr>
            </tbody>
        </table>
        <hr>
    </div>
</x-container>
@endsection