@extends('layouts.backend')
@section('title', "Transactions")
@section('content')
<x-container title="transaction" buttonTitle="Add New" buttonRoute="{{ route('transactions.create') }}">
    <div class="table-responsive pt-0">
        <table class="table">
            <x-table.thead :headers="['Date','Debit Account','Credit Account','Amount','Type','Particulars','action']"></x-table.thead>
            <tbody>
            @foreach($collection as $row)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ @$row->date }}</td>
                    <td>{{ @$row->debitAccount->name }}</td>
                    <td>{{ @$row->creditAccount->name }}</td>
                    <td>{{ $row->amount }}</td>
                    <td>{{ ucfirst(str_replace('_', ' ', $row->invoice_type)) }}</td>
                    <td>{{ $row->particular }}</td>
                    <td class="d-flex gap-1">
                        <x-action.edit route="{{ route('transactions.edit', $row->id) }}"></x-action.edit>
                        <x-action.delete route="{{ route('transactions.destroy', $row->id) }}"></x-action.delete>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
</x-container>
@endsection