<!DOCTYPE html>
<html lang="{{ session()->get('locale') }}"
      data-layout="dark-layout" data-textdirection="ltr">
<head>
    <link rel="apple-touch-icon" href="{{ globalAsset(setting('favicon'), 'settings') }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ globalAsset(setting('favicon'), 'settings') }}">
    @include('layouts.partials.metatag')
    <title>{{ config('app.name') }} - Login</title>
    @include('layouts.partials.stylesheet')
    <style>
        body {
            background-size: cover;
            background-image: url('{{ asset('images/login-bg.webp') }}'); /* Add image URL here */
        }

        .navbar {
            background: #fff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            border-radius: 15px;
        }

        .navbar .navbar-brand img {
            height: 50px;
            padding: 6px 0px;
        }

        .login-container {
            background: #fff;
            padding: 0px;
            border-radius: 20px;
            overflow: hidden;
        }

        .form-label {
            font-size: 15px;
            color: #1d1d1d;
            font-weight: 500;
        }

        .login-left {
            background: #e8f5e9;
            padding: 29px;
        }

        .col-md-6.login-right {
            padding: 30px;
        }

        .nav-link {
            color: #000000;
        }
    </style>
</head>
<body>


<!-- Main Content -->
<div class="container-lg">
    @if(env('APP_DEMO'))
        <nav class="navbar navbar-expand-lg bg-body-tertiary mt-1">
            <div class="container-fluid">
                <a class="navbar-brand" href="#">
                    <img src="{{ globalAsset(setting('logo')) }}" alt="Logo" class="d-inline-block align-text-top">
                </a>
                <button class="navbar-toggler border" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                    <span class="fa fa-bars text-secondary"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                        <li class="nav-item"><a class="nav-link" target="_blank"
                                                href="https://codecanyon.net/user/ayaantec">About Us</a></li>
                        <li class="nav-item"><a class="nav-link" target="_blank"
                                                href="https://pharma.ayaantec.com/index.html">Documentations</a></li>
                        <li class="nav-item"><a class="nav-link" target="_blank"
                                                href="https://www.youtube.com/@ayaantechlimited1524">Tutorial</a></li>
                    </ul>
                </div>
            </div>
        </nav>
    @endif

    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="row login-container mt-5 mx-1">
                <!-- Left Section -->
                <div class="col-md-6 login-left d-none d-lg-block">
                    <img src="{{ asset('images/login.webp') }}" class="img-fluid" alt="Pharmacy Management Image">
                    <!-- Replace with actual image path -->
                </div>
                <!-- Right Section -->
                <div class="col-md-6 login-right">
                    <h1 class="text-center my-2">Admin Login</h1>
                    <form action="{{ route('login') }}" method="POST">
                        <div class="mb-1">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" name="email" class="form-control @error('email') is-invalid @enderror"
                                   id="email" placeholder="company@example.com">
                            @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong class="text-danger">{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="mb-1">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" name="password"
                                   class="form-control @error('password') is-invalid @enderror" id="password"
                                   placeholder="Enter your password">

                            @error('password')
                            <span class="invalid-feedback" role="alert">
                            <strong class="text-danger">{{ $message }}</strong>
                        </span>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-success w-100">Login</button>
                        <div class="text-center footer-links mt-1">
                            <a href="#">Forgot your password?</a>
                        </div>
                    </form>
                    @if(env('DEFAULT_LOGIN'))
                        <div class="d-flex flex-lg-fill flex-wrap gap-1 mt-1">
                            <form action="{{ route('login') }}" method="POST">
                                <input type="hidden" name="email" value="superadmin@gmail.com">
                                <input type="hidden" name="password" value="12345678">
                                <button type="submit" class="btn btn-sm btn-light">Super Admin</button>
                            </form>
                            @if(isModuleActive('MultiStore'))
                                <form action="{{ route('login') }}" method="POST">
                                    <input type="hidden" name="email" value="superadmin@gmail.com">
                                    <input type="hidden" name="password" value="12345678">
                                    <button type="submit" class="btn btn-sm btn-light">Store Owner</button>
                                </form>
                            @endif
                            <form action="{{ route('login') }}" method="POST">
                                <input type="hidden" name="email" value="superadmin@gmail.com">
                                <input type="hidden" name="password" value="12345678">
                                <button type="submit" class="btn btn-sm btn-light">Doctor</button>
                            </form>

                            <form action="{{ route('login') }}" method="POST">
                                <input type="hidden" name="email" value="superadmin@gmail.com">
                                <input type="hidden" name="password" value="12345678">
                                <button type="submit" class="btn btn-sm btn-light">Sales Rep</button>
                            </form>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@include('layouts.partials.script')
</body>
</html>