@props([
'excel' => true,
'pdf' => true,
'table' => null,
'excelUrl' => null,
'pdfUrl' => null,
])

@if($excel)
    <a href="javascript:" onclick="excelExport()" class="btn btn-success text-light rounded-0">
        <i class="fa fa-file-excel"></i> {{ translate('common.Excel') }}
    </a>
@endif
@if($pdf)
    <a href="javascript:" onclick="pdfExport()" class="btn btn-warning text-light rounded-0">
        <i class="fa fa-file-pdf"></i> {{ translate('common.PDF') }}
    </a>
@endif

<script>
    function excelExport(){
        let currentUrl = new URL(window.location.href);
        currentUrl.searchParams.set('excel_export', 1);
        window.location.href = currentUrl.toString();
    }

    function pdfExport() {
        let currentUrl = new URL(window.location.href);
        currentUrl.searchParams.set('pdf_export', 1);
        window.location.href = currentUrl.toString();
    }
</script>