@extends('layouts.backend')
@section('title', "Expense categories")
@section('content')
<x-container title="Expense Categories" buttonTitle="Add New" buttonRoute="{{ route('expense-categories.create') }}">
    <div class="table-responsive pt-0">
        <table class="table">
            <x-table.thead :headers="['Category Name','Description','status','action']"></x-table.thead>
            <tbody>
            @foreach($collection as $row)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $row->name }}</td>
                    <td>{{ $row->description }}</td>
                    <td>{{ $row->status }}</td>
                    <td class="d-flex gap-1">
                        <x-action.edit route="{{ route('expense-categories.edit', $row->id) }}"></x-action.edit>
                        <x-action.delete route="{{ route('expense-categories.delete', $row->id) }}"></x-action.delete>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
</x-container>
@endsection