@extends('layouts.backend')
@section('title', "Add new expense")
@section('content')
    <x-container title="Add new expense" buttonTitle="Back" buttonRoute="{{ route('expenses.index') }}">
        <form action="{{route('expenses.store')}}" method="post" class="row">
            @csrf
            <x-form.input
                    :required="true"
                    type="date"
                    name="date"
                    label="Expense Date"
                    value="{{ @old('date') }}"
                    col="col-md-6">
            </x-form.input>
            <x-form.select
                    :required="true"
                    name="category_id"
                    label="Category"
                    value="{{ @old('category_id') }}"
                    col="col-md-6">
                @foreach($categories as $category)
                    <option value="{{$category->id}}">{{ $category->name }}</option>
                @endforeach
            </x-form.select>
            <x-form.input
                    :required="true"
                    name="title"
                    label="Expense for"
                    value="{{ @old('title') }}"
                    col="col-md-6">
            </x-form.input>
            <x-form.input
                    :required="true"
                    type="number"
                    name="amount"
                    label="Amount"
                    value="{{ @old('amount') }}"
                    col="col-md-6">
            </x-form.input>
            <x-form.select
                    :required="true"
                    name="account_id"
                    label="Debit Account"
                    col="col-md-6">
                @foreach($accounts as $account)
                    <option value="{{ $account->id }}" {{ @$account->id == old('account_id') ? 'selected':'' }} >
                        {{ $account->name }}
                    </option>
                @endforeach
            </x-form.select>
            <div> </div>
            <x-form.textarea
                    name="reference"
                    label="Reference"
                    value="{{ @old('reference') }}"
                    col="col-md-6">
            </x-form.textarea>
            <x-form.textarea
                    name="note"
                    label="Note"
                    value="{{ @old('note') }}"
                    col="col-md-6">
            </x-form.textarea>

            <x-form.button></x-form.button>
        </form>
    </x-container>
@endsection