@extends('layouts.app')
@section('title', translate('common.invoice_reports'))
@section('custom-css')
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css"/>
@endsection
@section('content')
    <x-container title="{{ translate('Profit and Loss') }}">
        <div class="row">
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="smalll-box d-flex justify-content-between">
                        <div class="inner">
                            <h4 class="text-white">
                                {{ priceFormat($total_sale_balance) }}</h4>
                            <p class="text-white">Total Sales</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="smalll-box d-flex justify-content-between">
                        <div class="inner">
                            <h4 class="text-white">
                                {{ priceFormat($total_profit_balance) }}</h4>
                            <p class="text-white">Total Profit</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="smalll-box d-flex justify-content-between">
                        <div class="inner">
                            <h4 class="text-white">
                                {{ priceFormat(abs($total_loss_balance)) }}</h4>
                            <p class="text-white">Total Loss</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-primary">
                    <div class="smalll-box d-flex justify-content-between">
                        <div class="inner">
                            <h4 class="text-white">
                                {{ priceFormat($balanceInhand) }}</h4>
                            <p class="text-white">Balance In Hand</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row justify-content-between align-items-center my-1">
            <div class="col-md-3">
                <form method="get">
                    <div class="col-md-12 user_role">
                        <label class="form-label" for="UserRole">{{ translate('common.from_date') }}</label>
                        <input value="@php echo $from_date @endphp  - @php echo $to_date @endphp" type="text"
                               name="date" id="reportrange"
                               class="form-control invoice-edit-input date-picker flatpickr-input">
                    </div>
                </form>
            </div>

            <div class="col-lg-6 text-end">
                <x-table.export-option/>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table">
                <thead>
                <tr>
                    <th>{{ translate('common.date') }}</th>
                    <th>{{ translate('Sales Invoice Qty') }}</th>
                    <th>{{ translate('Sales Amount') }}</th>
                    <th>{{ translate('Buy Amount') }}</th>
                    <th>{{ translate('Profit') }}</th>
                    <th>{{ translate('Loss') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($reports as $report)
                    <tr>
                        <th>{{ $report['date'] }}</th>
                        <th>{{ $report['quantity'] }}</th>
                        <th>{{ priceFormat($report['amounts']) }}</th>
                        <th>{{ priceFormat($report['buy_amount']) }}</th>
                        <th>{{ priceFormat($report['profit']) }}</th>
                        <th>{{ priceFormat(abs($report['loss'])) }}</th>
                    </tr>
                @endforeach

                <input type="hidden" id="total"
                       value="{{ priceFormat($total_profit_balance) }}">

                </tbody>


            </table>
        </div>

    </x-container>
@endsection

@section('custom-js')

    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    @php
        $date = date('Y-m-d', strtotime('-7 day', time()));
    @endphp
    <script type="text/javascript">
        $(function () {

            var pvlpaid = $("#total").val();
            console.log(pvlpaid)
            $('#totaldue').html(pvlpaid);
            var start = moment().subtract(29, 'days');
            var end = moment();

            var d = new Date();

            var up = function (start, end) {

                window.location.href = "?from=" + start + "&to=" + end;
            }

            $('input[name="date"]').daterangepicker({
                startDate: start,
                endDate: end,
                format: 'YYYY-MM-DD',
                timePicker: false,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')]
                }
            }, function (start, end, label) {
                var start2 = start.format("YYYY-MM-DD");
                var end2 = end.format("YYYY-MM-DD");

                window.start = start2;
                window.end = end2;

                up(start2, end2);
            });
        });
    </script>
@endsection
