@extends('layouts.backend')
@section('title', "Edit language")
@section('content')
    <x-container title="Edit language" buttonTitle="Back" buttonRoute="{{ route('language.index') }}">
        <form action="{{route('language.update', $language->id)}}" method="post" class="row" enctype="multipart/form-data">
            @csrf
            @method('put')
            <x-form.input
                    name="name"
                    label="Name"
                    value="{{ $language->name }}"
                    placeholder="ex: english"
                    col="col-md-6">
            </x-form.input>
            <x-form.input
                    name="iso"
                    label="ISO"
                    value="{{ $language->iso }}"
                    placeholder="ex: en"
                    col="col-md-6">
            </x-form.input>
            <x-form.file
                    name="icon"
                    label="Icon"
                    col="col-md-6"
                    value="{{ $language->icon }}"
            ></x-form.file>
            <x-form.select
                    name="status"
                    label="Status"
                    value="{{ @old('status') }}"
                    col="col-md-6">
                <option value="1" {{ $language->status == 1 ? 'selected' : '' }} >{{ translate('Active') }}</option>
                <option value="1" {{ $language->status == 0 ? 'selected' : '' }}>{{ translate('Inactive') }}</option>
            </x-form.select>
            <x-form.button></x-form.button>
        </form>
    </x-container>
@endsection