@extends('layouts.app')
@section('title', translate('common.edit_supplier'))
@section('content')
    <x-container title="Edit Supplier" buttonTitle="Back" buttonRoute="{{ route('supplier.index') }}">
        <form class="form" method="POST" action="{{ route('supplier.update', $customer->id) }}">
            @csrf
            @method('put')
            <div class="row">
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="first-name-column">{{ translate('common.name') }}</label>
                        <input type="text" id="first-name-column" class="form-control"
                               placeholder="{{ translate('common.name') }}" value="{{ $customer->name }}"
                               name="name" required>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="last-name-column">{{ translate('common.address') }}</label>
                        <input type="text" id="last-name-column" class="form-control"
                               placeholder="{{ translate('common.address') }}"
                               value="{{ $customer->address }}" name="address" required>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="city-column">{{ translate('common.phone') }}</label>
                        <input type="text" id="city-column" class="form-control"
                               placeholder="{{ translate('common.phone') }}"
                               value="{{ $customer->phone }}" name="phone" required>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="country-floating">{{ translate('Payable') }}</label>
                        <input type="number" value="{{ old('due', $customer->due) }}" step="0.01" id="country-floating" class="form-control"
                               name="due" placeholder="{{ translate('common.payable') }}">
                    </div>
                </div>

                <div class="col-12">
                    <button type="submit"
                            class="btn btn-primary me-1 waves-effect waves-float waves-light">{{ translate('common.submit') }}</button>
                </div>
            </div>
        </form>
    </x-container>
@endsection
