@extends('layouts.app')
@section('title', translate('common.supplier_list'))
@section('custom-css')
@endsection
@section('content')
    <x-container title="supplier list" buttonRoute="{{ route('supplier.create') }}" buttonTitle="Add New">
        <div class="table-responsive">
            <table class="user-list-table table">
                <thead class="table-light">
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.name') }}</th>
                    <th>{{ translate('common.phone') }}</th>
                    <th>{{ translate('common.payable') }}</th>
                    <th>{{ translate('common.address') }}</th>
                    <th>{{ translate('common.Action') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ $row->phone }}</td>
                        <td>{{ priceFormat($row->due) }}</td>
                        <td>{{ $row->address }}</td>
                        <td class="d-flex gap-1">
                            <x-action.edit  route="{{ route('supplier.edit', $row->id) }}"></x-action.edit>
                            <x-action.show  route="{{ route('supplier.show', $row->id) }}"></x-action.show>
                            <x-action.delete route="{{ route('supplier.delete', $row->id) }}"></x-action.delete>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <div class="pagination">
            {!! $collection->links() !!}
        </div>
    </x-container>
@endsection

@section('custom-js')

@endsection
