@extends('layouts.app')
@section('title', translate('common.type_edit'))
@section('content')
    <x-container title="type edit" buttonTitle="Back" buttonRoute="{{ route('type.index') }}">
        <form class="form" method="POST" action="{{ route('type.update', $type->id) }}">
            @csrf
            @method('put')
            <div class="row">
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="first-name-column">{{ translate('common.name') }}</label>
                        <input type="text" id="first-name-column" class="form-control"
                               placeholder="{{ translate('common.name') }}" value="{{ $type->name }}"
                               name="name" required>
                    </div>
                    @error('name')
                     <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="col-12">
                    <button type="submit"
                            class="btn btn-primary me-1 waves-effect waves-float waves-light">{{ translate('common.submit') }}</button>
                    <button type="reset"
                            class="btn btn-outline-secondary waves-effect">{{ translate('common.reset') }}</button>
                </div>
            </div>
        </form>
    </x-container>
@endsection
