<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class MigrateNext extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'migrate:next';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run migrations from new folder';

    // Specify your fixed folder name here
    private $migrationsFolder = 'new'; // Change this to your folder name

    /**
     * Execute the console command.
     */
    public function handle()
    {

        $path = "database/migrations/{$this->migrationsFolder}";
        $this->info("Running custom migrations from: $path");

        // Run migrations from the specified folder
        Artisan::call('migrate', ['--path' => $path]);

        $this->info('Next migrations executed successfully.');
    }
}
