<?php

namespace App\Http\Controllers;

use App\Models\ExpenseCategory;
use Illuminate\Http\Request;

class ExpenseCategoryController extends Controller
{
    public function index()
    {
        $collection = ExpenseCategory::latest('id')->get();
        return view('expense_category.index', compact('collection'));
    }

    public function create()
    {
        return view('expense_category.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'status' => 'required',
        ]);
        try {
            // Validation goes here

            // Create the new record
            ExpenseCategory::create($request->all());

            // Success message
            successAlert('Created successfully');
            return redirect()->route('expense-categories.index');
        } catch (\Exception $e) {
            // Error message
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        $expenseCategory = ExpenseCategory::find($id);
        return view('expense_category.edit', compact('expenseCategory'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'status' => 'required',
        ]);
        try {
            $expenseCategory = ExpenseCategory::find($id);
            $expenseCategory->update($request->all());
            successAlert('Updated successfully');
            return redirect()->route('expense-categories.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function delete($id)
    {
        try {
            $expenseCategory = ExpenseCategory::find($id);
            $expenseCategory->delete();
            successAlert('Deleted successfully');
            return redirect()->route('expense-categories.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }
}
