<?php

namespace App\Http\Controllers;

use App\Models\Balance;
use App\Models\Medicine;
use App\Models\Vendor;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\DataTables;

class VendorController extends Controller
{
    public function index(Request $request)
    {
        $collection = Vendor::with('medicine:id,name')->latest()
            ->paginate(10);
        return view('vendor.list', compact('collection'));
    }

    public function create()
    {
        return view('vendor.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'phone' => 'required',
            'address' => 'required',
        ]);

        $data = $request->all();
        $data['name'] = $request->name;
        $data['phone'] = $request->phone;
        $data['address'] = $request->address;
        $data['due'] = $request->due;
        $data['payable'] = $request->payable;
        
        $res = Vendor::create($data);
        if ($res) {
            Toastr::success('Vendor successfully created', '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
            return redirect()->route('vendor.index');
        }
    }


    public function show(Vendor $vendor)
    {
        $res = $vendor->delete();
        if ($res) {
            Toastr::success('Vendor successfully deleted', '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
            return redirect()->route('vendor.index');
        }
    }


    public function edit($id)
    {
        $vendor  = Vendor::find($id);
        return view('vendor.edit', compact('vendor'));
    }


    public function update(Request $request, Vendor $vendor)
    {
        $request->validate([
            'name' => 'required',
            'phone' => 'required',
            'address' => 'required'
        ]);
        $data = $request->all();
        $res = $vendor->update($data);
        if ($res) {
            Toastr::success('Vendor successfully updated', '', ['progressBar' => true, 'closeButton' => true, 'positionClass' => 'toast-top-right']);
            return redirect()->route('vendor.index');
        }
    }

    public function delete($id)
    {
        try {
            $vendor = Vendor::find($id);
            $vendor->delete();
            successAlert('Vendor deleted successfully');
            return redirect()->route('vendor.index');
        }catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }
}
