<?php

namespace App\Models;

use App\Models\Ecommerce\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductCategory extends BaseModel
{
    use HasFactory;
    protected  $guarded = [];

    public static function product($id,$limit = 999)
    {
        $products = [];
        $all_products = Product::get();
        $count = 0;

        foreach ($all_products as $product) {
            $product_types = json_decode($product->categories, true);

            if (is_array($product_types) && in_array($id, $product_types)) {
                $products[] = $product;
                $count++;
            }

            if ($count == $limit) {
                break;
            }
        }

        return $products;
    }
}
