<?php


namespace App\Service;


use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class SupplierPayableExcelExport implements FromView
{
    protected $suppliers;
    protected $total_previous_payable;
    protected $total_invoice_payable;

    public function __construct($suppliers, $total_previous_payable, $total_invoice_payable)
    {
        $this->suppliers = $suppliers;
        $this->total_previous_payable = $total_previous_payable;
        $this->total_invoice_payable = $total_invoice_payable;
    }

    public function view(): View
    {
        return view('exports.supplier_payable_report', [
            'reports' => $this->suppliers,
            'total_previous_payable' => $this->total_previous_payable,
            'total_invoice_payable' => $this->total_invoice_payable,
        ]);
    }
}