<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->integer('employee_id');
            $table->string('first_name');
            $table->string('last_name');
            $table->integer('designation_id');
            $table->integer('department_id');
            $table->string('phone');
            $table->string('email');
            $table->string('rate_type');
            $table->string('hrate');
            $table->string('blood_group');
            $table->string('gender');
            $table->text('address_one');
            $table->text('address_two');
            $table->string('country');
            $table->string('city');
            $table->string('image');
            $table->enum('status',['active','inactive'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
