@extends('layouts.backend')
@section('title', translate('common.dashboard'))
@section('content')
    <div class="row">
        <x-stats-card title="Total Medicines" value="{{ $medicine }}" icon="fas fa-pills"/>
        <x-stats-card title="Instock Medicines" value="{{ number_format($instock_medicine, 0, '.', ',') }}"
                      icon="fas fa-pills"/>
        <x-stats-card title="Stockout Medicines" value="{{ $stockout->count() }}" icon="fas fa-pills"/>
        <x-stats-card title="Expired Medicines" value="{{ $expire->count() }}" icon="fas fa-pills"/>

        <x-stats-card title="Total Product Sale" value="{{ $total_product_sale }}" icon="fa fa-print"/>
        <x-stats-card title="Today Product Sale" value="{{ $today_product_sale }}" icon="fa fa-print"/>
        <x-stats-card title="This Month Sale" value="{{ $product_sale_this_month }}" icon="fa fa-print"/>
        <x-stats-card title="This Year Product Sale" value="{{ $product_sale_this_year }}" icon="fa fa-print"/>

        <x-stats-card title="Total Product Purchase" value="{{ $total_product_purchase }}" icon="fa fa-chart-column"/>
        <x-stats-card title="Today Product Purchase" value="{{ $today_product_purchase }}" icon="fa fa-chart-column"/>
        <x-stats-card title="This Month Purchase" value="{{ $product_purchase_this_month }}" icon="fa fa-chart-column"/>
        <x-stats-card title="This Year Product Purchase" value="{{ $product_purchase_this_year }}" icon="fa fa-chart-column"/>

        <x-stats-card title="Total Earning" value="{{ priceFormat($total_earning) }}" icon="fa fa-dollar-sign"/>
        <x-stats-card title="Today Earning" value="{{ priceFormat($today_earning) }}" icon="fa fa-dollar-sign"/>
        <x-stats-card title="This Month Earning" value="{{ priceFormat($earning_this_month) }}" icon="fa fa-dollar-sign"/>
        <x-stats-card title="This Year Erning" value="{{ priceFormat($earning_this_year) }}" icon="fa fa-dollar-sign"/>

        <x-stats-card title="Total Customers" value="{{ $total_customers }}" icon="fa fa-users" />
        <x-stats-card title="Total Suppliers" value="{{ $total_suppliers }}" icon="fa fa-users"/>
        <x-stats-card title="Total Categories" value="{{ $total_categories }}" icon="fa fa-list-check"/>
        <x-stats-card title="Total Transactions" value="{{ $total_transactions }}" icon="fa fa-money-bill" />
    </div>
    <div id="stockmodal" class="modal fade show" role="dialog" style="padding-right: 15px; display: none;"
         aria-modal="true">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header d-flex justify-content-between">
                    <h4 class="modal-title">{{ translate('common.expired_medicine') }}</h4>
                    <button type="button" class="close btn btn-sm btn-light" data-bs-dismiss="modal">×</button>
                </div>
                <div class="modal-body">
                    <table id="" class="table table-bordered table-striped table-hover">
                        <thead>
                        <tr>
                            <th class="text-center">{{ translate('common.name') }}</th>
                            <th class="text-center">{{ translate('common.batch') }}</th>
                            <th class="text-center">{{ translate('common.Expired on') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($expire_medicines as $batch)
                            <tr>
                                <td>
                                    @php
                                        $medicine = \App\Models\Medicine::where('id', $batch->medicine_id)->first();
                                    @endphp
                                    @if ($medicine != null)
                                        {{ $medicine->name }}
                                    @endif
                                </td>
                                <td>{{ $batch->name }}</td>

                                <td>{{ $batch->expire }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    <div>
                        <h4>
                            <center>{{ translate('common.stock_out') }}</center>
                        </h4>
                    </div>
                    <table id="" class="table table-bordered table-striped table-hover">
                        <thead>
                        <tr>
                            <th class="text-center">{{ translate('common.name') }}</th>

                            <th class="text-center">{{ translate('Qauntity') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($stockout_medicines as $medicine)
                            <tr>
                                <td class="text-center">
                                    {{ $medicine->name }}
                                </td>
                                <td class="text-center">
                                    {{ $medicine->total_quantity }}
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <input type="hidden" name="is_modal_shown" id="is_modal_shown">
                    <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-js')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#stockmodal').modal('show');
        });
    </script>

    <script src="{{ asset('dashboard/app-assets/morris-chart/popper.min.js') }}"></script>
    <script src="{{ asset('dashboard/app-assets/morris-chart//raphael-min.js') }}"></script>
    <script src="{{ asset('dashboard/app-assets/morris-chart/morris.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    @php
        $dfrom = date('Y-m-d', strtotime('-7 day', time()));
        $dto = date('Y-m-d');
        $datelist = list_days($dfrom, $dto);
        $i = 0;
        $data = [];
    @endphp
    @foreach ($datelist as $date)
        @php
            $data[$i]['y'] = $date;
            $data[$i]['a'] = \App\Models\Invoice::where('shop_id', Auth::user()->shop_id)
                ->where('date', $date)
                ->count();
            $data[$i]['b'] = \App\Models\Purchase::where('shop_id', Auth::user()->shop_id)
                ->where('date', $date)
                ->count();
            $i++;
        @endphp
    @endforeach
    <script>
        Morris.Line({
            element: 'line-example',
            data: @php echo json_encode($data) @endphp,
            xkey: 'y',
            labelColor: '#000000',
            ykeys: ['a', 'b'],
            labels: ['Sales', 'Purchase']
        });
    </script>

    @php
        $sales = \App\Models\Invoice::sum('total_price');
        $purchase = \App\Models\Purchase::sum('total_price');
    @endphp

    <script>
        var options = {
            series: [{{ $purchase }}, {{ $sales }}],
            chart: {
                width: 380,
                type: 'pie',
            },
            colors: ['#0088ff', '#f8bf15'],
            labels: ['Purchase', 'Sales'],
            legend: {
                position: 'bottom',
                show: true,
                showForSingleSeries: false,
                showForNullSeries: true,
                showForZeroSeries: true,
            },
        };

        var chart = new ApexCharts(document.querySelector("#piChart"), options);
        chart.render();
    </script>
@endsection
