@extends('layouts.backend')
@section('title', "Add new expense categories")
@section('content')
    <x-container title="Add new expense categories" buttonTitle="Back" buttonRoute="{{ route('expense-categories.index') }}">
        <form action="{{route('expense-categories.store')}}" method="post" class="row">
            @csrf
            <x-form.input
                    :required="true"
                    name="name"
                    label="Name"
                    value="{{ @old('name') }}"
                    col="col-md-6">
            </x-form.input>
            <x-form.select
                    name="status"
                    label="Status"
                    value="{{ @old('status') }}"
                    col="col-md-6">
                <option value="active" selected>{{ translate('common.Active') }}</option>
                <option value="inactive">{{ translate('common.Inactive') }}</option>
            </x-form.select>

            <x-form.textarea
                    name="description"
                    label="Description"
                    value="{{ @old('description') }}">
            </x-form.textarea>

            <x-form.button></x-form.button>
        </form>
    </x-container>
@endsection