<!DOCTYPE html>
<html class="loading @if (setting('theme') == 'dark') dark-layout @endif" lang="{{ session()->get('locale') }}"
      data-layout="dark-layout" data-textdirection="ltr">
<head>
    @include('layouts.partials.metatag')
    <title>Admin {{ setting('name') }} - @yield('title')</title>

    @include('layouts.partials.stylesheet')

    @yield('custom-css')
    @stack('css')
    <style>
        @media print {
            .header-navbar{
                display: none !important;
            }
            .main-menu {
                display: none !important;
            }
            .page-wrapper .card{
                border-top: unset !important;
            }
            footer{
                display: none !important;
            }
            .card-header nav{
                display: none !important;
            }
            .pagetitle{
                display: none;
            }
            .card{
                box-shadow: none;
            }
            #window-printer{
                display: none;
            }
        }
    </style>
</head>

<body class="vertical-layout vertical-menu-modern navbar-floating footer-static" data-open="click"
      data-menu="vertical-menu-modern" data-col="">
<!-- Header -->
@include('layouts.partials.header')
<div class="main-menu menu-fixed menu-dark menu-accordion menu-shadow" data-scroll-to-active="true">
    <div class="navbar-header mb-2">
        <ul class="nav navbar-nav flex-row justify-content-between">
            <li class="nav-item me-auto">
                <a class="navbar-brand" href="{{ route('dashboard') }}">
                        <span class="brand-logo">
                            <img height="40" width="160" src="{{ globalAsset(setting('logo'), 'settings') }}" alt="Logo"/>
                        </span>
                    <h4 class="brand-text">{{ setting('name') }}</h4>
                </a>
            </li>
            <li class="nav-item nav-toggle">
                <a class="nav-link modern-nav-toggle pe-0" data-bs-toggle="collapse">
                    <i class="d-block d-xl-none text-primary toggle-icon font-medium-4" data-feather="x"></i>
                    <i class="d-none d-xl-block collapse-toggle-icon font-medium-4  text-primary"
                       data-feather="disc" data-ticon="disc"></i>
                </a>
            </li>
        </ul>
    </div>
    <div class="shadow-bottom"></div>
    <div class="main-menu-content">
        @include('layouts.partials.sidebar')
    </div>
</div>
<!-- End Sidebar -->


<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
        </div>
        <div class="content-body">
            @yield('content')
            @include('layouts.partials.footer')
        </div>
    </div>
</div>
<div class="sidenav-overlay"></div>
<div class="drag-target"></div>

<button class="btn btn-primary btn-icon scroll-top" type="button"><i data-feather="arrow-up"></i></button>

@include('layouts.partials.script')

@yield('custom-js')
@stack('js')

<!-- END: Page JS-->

<script>
    $(window).on('load', function () {
        if (feather) {
            feather.replace({
                width: 14,
                height: 14
            });
        }
    })

    $(document).ready(function() {
        $('#imageInput').change(function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    $('#imagePreview').attr('src', e.target.result);
                    $('#imagePreview').show();
                }
                reader.readAsDataURL(file);
            }
        });
    });
</script>

{!! Toastr::message() !!}

</body>
</html>
