@extends('layouts.app')
@section('title', translate('common.medicine_add'))
@section('custom-css')
    <link rel="stylesheet" type="text/css"
        href="{{ asset('dashboard/app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/app-assets/vendors/css/forms/select/select2.min.css') }}">
    <link rel="stylesheet" type="text/css"
        href="{{ asset('dashboard/app-assets/css/plugins/forms/pickers/form-flat-pickr.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('dashboard/app-assets/css/pages/app-invoice.css') }}">
@endsection
@section('content')
    <section id="basic-horizontal-layouts">
        <section id="multiple-column-form">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">{{ translate('common.medicine_add') }}</h4>
                        </div>
                        <div class="card-body">
                            <form class="form" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.qr_code') }}</label>
                                            <input type="text" id="first-name-column" class="form-control"
                                                placeholder="{{ translate('common.qr_code') }}" name="qr_code">
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.Hns Code') }}</label>
                                            <input type="text" id="first-name-column" class="form-control"
                                                placeholder="{{ translate('common.Hns Code') }}" name="hns_code">
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label" for="first-name-column">{{ translate('common.name') }}
                                                <font color="red">*</font>
                                            </label>
                                            <input type="text" id="first-name-column" class="form-control"
                                                placeholder="{{ translate('common.name') }}" name="name" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.strength') }}</label>
                                            <input type="text" id="first-name-column" class="form-control"
                                                placeholder="{{ translate('common.strength') }}" name="strength">
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.generic_name') }}</label>
                                            <input type="text" id="first-name-column" class="form-control"
                                                placeholder="{{ translate('common.generic_name') }}" name="generic_name">
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label" for="first-name-column">{{ translate('common.box_size') }}
                                                <font color="red">*</font>
                                            </label>
                                            <select class="select2 form-select" id="select2-basic" data-select2-id="select2-basic"
                                                    tabindex="-1" aria-hidden="true" name="leaf_id" required>
                                                <option value="">{{ translate('Select Box Size') }}</option>
                                                @foreach ($leaf as $leafs)
                                                    <option value="{{ $leafs->id }}">{{ $leafs->name }}
                                                        ({{ $leafs->amount }}</option>)
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.shelf') }}</label>
                                            <input type="text" id="first-name-column" class="form-control"
                                                placeholder="{{ translate('common.shelf') }}" name="shelf">
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.desc') }}</label>
                                            <input type="text" id="first-name-column" class="form-control"
                                                placeholder="{{ translate('common.desc') }}" name="des">
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.category') }}
                                                <font color="red">*</font>
                                            </label>
                                            <select class="select2 form-select" id="select2-basic"
                                                data-select2-id="select2-basic" tabindex="-1" aria-hidden="true"
                                                name="category_id" required>
                                                <option value="">{{ translate('Select Category') }}</option>
                                                @foreach ($category as $leafs)
                                                    <option value="{{ $leafs->id }}">{{ $leafs->name }} </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.image') }}</label>
                                            <input class="form-control" type="file" name="image" id="formFile">
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.price') }}
                                                <font color="red">*</font>
                                            </label>
                                            <input type="number" step="0.01" id="first-name-column"
                                                class="form-control" placeholder="{{ translate('common.price') }}"
                                                name="price" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label" for="first-name-column">Vendor</label>

                                            <select class="select2 form-select" id="select2-basic"
                                                data-select2-id="select2-basic" tabindex="-1" aria-hidden="true"
                                                name="vendor_id">
                                                <option value="">Select Vendor</option>
                                                @foreach ($vendors as $vendor)
                                                    <option value="{{ $vendor->id }}">{{ $vendor->name }} </option>
                                                @endforeach
                                            </select>

                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.supplier') }}
                                                <font color="red">*</font>
                                            </label>
                                            <select class="select2 form-select" id="select2-basic"
                                                data-select2-id="select2-basic" tabindex="-1" aria-hidden="true"
                                                name="supplier_id" required>
                                                <option value="">Select Supplier</option>
                                                @foreach ($supplier as $leafs)
                                                    <option value="{{ $leafs->id }}">{{ $leafs->name }} </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.buy_price') }} <font
                                                    color="red">*</font></label>
                                            <input type="number" step="0.01" id="first-name-column"
                                                class="form-control" placeholder="{{ translate('common.buy_price') }}"
                                                name="buy_price" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.vat') }} </label>
                                            <div class="input-group form-password-toggle mb-2">
                                                <input type="number" step="0.01" class="form-control"
                                                    placeholder="{{ translate('common.vat') }}" name="vat"
                                                    aria-describedby="basic-default-password">
                                                <span class="input-group-text cursor-pointer">
                                                    {{ Auth::user()->shop->currency }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.igta') }} </label>
                                            <div class="input-group form-password-toggle mb-2">
                                                <input type="number" step="0.01" class="form-control"
                                                    placeholder="{{ translate('common.igta') }}" name="igta"
                                                    aria-describedby="basic-default-password">
                                                <span class="input-group-text cursor-pointer">
                                                    {{ Auth::user()->shop->currency }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12">
                                        <div class="mb-1">
                                            <label class="form-label"
                                                for="first-name-column">{{ translate('common.status') }} </label>
                                            <div class="demo-inline-spacing">
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="status"
                                                        id="inlineRadio1" value="1">
                                                    <label class="form-check-label"
                                                        for="inlineRadio1">{{ translate('Active') }}</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" type="radio" name="status"
                                                        id="inlineRadio2" value="0">
                                                    <label class="form-check-label"
                                                        for="inlineRadio2">{{ translate('Inactive') }}</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">{{ translate('common.submit') }}</button>
                                        <button type="reset"
                                            class="btn btn-outline-secondary waves-effect">{{ translate('common.reset') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </section>
@endsection



@section('custom-js')
    <script src="{{ asset('dashboard/app-assets/vendors/js/forms/select/select2.full.min.js') }}"></script>

    <script src="{{ asset('dashboard/app-assets/js/scripts/forms/form-select2.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2({
                tags: true
            });
        });
    </script>
@endsection
