@extends('layouts.backend')
@section('title', "Add new Medicine")
@section('content')
    <x-container title="Add new Medicine" buttonTitle="Back" buttonRoute="{{ route('medicines.index') }}">
        <form action="{{route('medicines.store')}}" method="post" class="row" enctype="multipart/form-data">
            @csrf

            @include('medicine.form')

            <x-form.button></x-form.button>
        </form>
    </x-container>
@endsection

@push('js')
    <script>
        $(document).ready(function() {
        $('#barcodeGenerate').on('click', function(){
            $.ajax({
                url: "{{ route('barcode_generate') }}",
                type: 'get',
                dataType:'json',
                success: function(res) {
                    $('#barcode_input').val(res.barcode);
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    console.log(thrownError)
                }
            })
        });
            $('#imageInput').change(function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        $('#imagePreview').attr('src', e.target.result);
                        $('#imagePreview').show();
                    }
                    reader.readAsDataURL(file);
                }
            });
        });
    </script>
@endpush