@extends('layouts.backend')
@section('title', "General Settings")
@php

@endphp
@section('content')
    <x-container title="General Settings">
        <form class="form row" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="col-lg-8">
                <div class="row">
                    <x-form.input
                            col="col-lg-12"
                            name="app_name"
                            label="App name"
                            value="{{ setting('app_name') }}"
                    ></x-form.input>


                <x-form.input
                        col="col-lg-6"
                        name="currency"
                        label="Currency"
                        value="{{ setting('currency') }}"
                ></x-form.input>
                    <x-form.input
                            col="col-lg-6"
                            name="prefix"
                            label="Prefix"
                            value="{{ setting('prefix') }}"
                    ></x-form.input>
                <x-form.input
                        col="col-lg-6"
                        name="email"
                        label="Email"
                        value="{{ setting('email') }}"
                ></x-form.input>
                <x-form.input
                        col="col-lg-6"
                        name="phone"
                        label="Phone"
                        value="{{ setting('phone') }}"
                ></x-form.input>
                <x-form.input
                        col="col-lg-12"
                        name="address"
                        label="Address"
                        value="{{ setting('address') }}"
                ></x-form.input>
                <x-form.input
                        col="col-lg-6"
                        name="upcoming_expire_alert"
                        label="Upcoming Expire Alert"
                        value="{{ setting('upcoming_expire_alert') }}"
                ></x-form.input>
                <x-form.input
                        col="col-lg-6"
                        name="low_stock_alert"
                        label="Low Stock Alert"
                        value="{{ setting('low_stock_alert') }}"
                ></x-form.input>
                <x-form.select
                        col="col-lg-6"
                        name="time_zone"
                        label="Time Zone"
                >
                    @foreach (\DateTimeZone::listIdentifiers() as $timezone)
                        <option {{ setting('time_zone') == $timezone ? 'selected' : '' }}
                                value="{{ $timezone }}">{{ $timezone }}</option>
                    @endforeach
                </x-form.select>
                </div>
            </div>
            <div class="col-lg-4 mb-2">
                <div class="media-setting">
                    <div class="row gy-3">
                        <div class="col-md-12">
                            <label for="logo_image" class="form-label file-selectore">
                                <span class="label">{{ translate('common.Select Logo') }}</span>
                            </label>
                            <div class="d-block my-2">
                                @if (setting('logo'))
                                    <img height="55" width="250"
                                         src="{{ globalAsset(setting('logo'), 'settings')}}"
                                         alt="">
                                @endif
                            </div>
                            <input type="file" name="logo" id="logo_image">
                            <label
                                    class="text-muted mt-2">{{ translate('common.image size: 250 × 55 px') }}
                            </label>
                        </div>
                        <div class="col-md-12">
                            <label for="favicon_image" class="form-label file-selectore">
                                                        <span
                                                                class="label">{{ translate('common.Select Favicon') }}</span>
                            </label>
                            <div class="d-block my-2">
                                @if (setting('favicon'))
                                    <img height="128" width="128"
                                         src="{{ @globalAsset(setting('favicon'), 'settings') }}"
                                         alt="">
                                @endif
                            </div>
                            <input type="file" name="favicon" id="favicon_image">
                            <label class="text-muted mt-2">
                                {{ translate('common.image size: 128 × 128 px') }}
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <x-form.button title="Save Changes"></x-form.button>
        </form>
    </x-container>
@endsection