@extends('layouts.app')
@section('title', translate('common.edit_vendor'))
@section('content')
    <x-container title="edit vendor" buttonRoute="{{ route('vendor.index') }}" buttonTitle="Back">
        <form class="form" method="POST" action="{{ route('vendor.update', $vendor->id) }}">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="first-name-column">{{ translate('common.name') }}</label>
                        <input type="text" id="first-name-column" class="form-control"
                               placeholder="{{ translate('common.name') }}" value="{{ $vendor->name }}"
                               name="name" required>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="last-name-column">{{ translate('common.address') }}</label>
                        <input type="text" id="last-name-column" class="form-control"
                               placeholder="{{ translate('common.address') }}"
                               value="{{ $vendor->address }}" name="address" required>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="city-column">{{ translate('common.phone') }}</label>
                        <input type="text" id="city-column" class="form-control"
                               placeholder="{{ translate('common.phone') }}" value="{{ $vendor->phone }}"
                               name="phone" required>
                    </div>
                </div>
                <div class="col-md-3 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="country-floating">{{ translate('Payable') }}</label>
                        <input type="number" step="0.01" id="country-floating" class="form-control"
                               name="payable" placeholder="{{ translate('common.payable') }}"
                               value="{{ $vendor->payable }}">
                    </div>
                </div>

                <div class="col-md-3 col-12">
                    <div class="mb-1">
                        <label class="form-label" for="country-floating">{{ translate('Due') }}</label>
                        <input type="number" step="0.01" id="country-floating" class="form-control"
                               name="due" placeholder="{{ translate('common.due') }}"
                               value="{{ $vendor->due }}">
                    </div>
                </div>

                <div class="col-12">
                    <button type="submit"
                            class="btn btn-primary me-1 waves-effect waves-float waves-light">{{ translate('common.submit') }}</button>
                    <button type="reset"
                            class="btn btn-outline-secondary waves-effect">{{ translate('common.reset') }}</button>
                </div>
            </div>
        </form>
    </x-container>
@endsection
