@extends('layouts.app')
@section('title', translate('common.vendor_list'))

@section('content')
    <x-container title="Vendor List" buttonRoute="{{ route('vendor.create') }}" buttonTitle="Add New">
        <div class="table-responsive">
            <table class="table">
                <thead>
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.name') }}</th>
                    <th>{{ translate('common.phone') }}</th>
                    <th>{{ translate('common.due') }} </th>
                    <th>{{ translate('common.payable') }} </th>
                    <th>{{ translate('common.address') }}</th>
                    <th>{{ translate('common.option') }}</th>
                </tr>
                </thead>
                <tbody>
                @forelse($collection as $key => $row)
                    <tr>
                        <td>{{ $key+1 }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ $row->phone }}</td>
                        <td>{{ $row->due }}</td>
                        <td>{{ $row->payable }}</td>
                        <td>{{ $row->address }}</td>
                        <td class="d-flex gap-1">
                            <x-action.edit  route="{{ route('vendor.edit', $row->id) }}"></x-action.edit>
                            <x-action.delete route="{{ route('vendor.delete', $row->id) }}"></x-action.delete>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td><h4>No data Found</h4></td>
                    </tr>
                @endforelse
                </tbody>
            </table>
            <div class="pagination">
                {!! $collection->links() !!}
            </div>
        </div>
    </x-container>
@endsection
