<?php

namespace App\Http\Controllers;

use App\Models\Leaf;
use Illuminate\Http\Request;

class LeafController extends Controller
{
    public function index(Request $request)
    {
        $collection = Leaf::latest()->paginate(10);
        return view('leaf.list', compact('collection'));
    }

    public function create()
    {
        return view('leaf.add');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:leaves,name',
        ]);
        try {
            $leaf = new Leaf();
            $leaf->name = $request->name;
            $leaf->amount = $request->qty;
            $leaf->save();
            successAlert('Leaf successfully created');
            return redirect()->route('leaf.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        $leaf = Leaf::find($id);
        return view('leaf.edit', compact('leaf'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|unique:leaves,name,' . $id, ',id',
        ]);
        try {
            $leaf = Leaf::find($id);
            $leaf->name = $request->name;
            $leaf->amount = $request->qty;
            $leaf->save();
            successAlert('Leaf successfully Updated');
            return redirect()->route('leaf.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function delete($id)
    {
        try {
            $leaf = Leaf::find($id);
            $leaf->delete();
            successAlert('Leaf successfully Deleted');
            return redirect()->route('leaf.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }
}
