<?php

namespace App\Http\Controllers;

use App\Models\Method;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PaymentController extends Controller
{
    public function index(Request $request)
    {
        $collection = Method::select('*', DB::raw('SUM(balance) as total_balance'))
            ->groupBy('name')
            ->latest()
            ->get();
        $total_balance = $collection->sum('balance');

        $history = Method::latest()->paginate(10);

        return view('method.list', compact('collection', 'total_balance','history'));
    }

    public function create()
    {
        return view('method.add');
    }

    public function store(Request $request)
    {
        $this->inputValidation($request);

        try {
            $method = new Method();
            $method->name = $request->name;
            $method->balance = $request->balance;
            $method->save();
            successAlert('Method successfully created');
            return redirect()->route('payment_method.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        $method = Method::find($id);
        return view('method.edit', compact('method'));
    }

    public function update(Request $request, $id)
    {
        $this->inputValidation($request, $id);

        try {
            $method = Method::find($id);
            $method->name = $request->name;
            $method->balance = $request->balance;
            $method->save();
            successAlert('Method successfully Updated');
            return redirect()->route('payment_method.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function delete($id)
    {
        try {
            $method = Method::find($id);
            $method->delete();
            successAlert('Method successfully Deleted');
            return redirect()->route('payment_method.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
        }
    }

    public function inputValidation($request, $id = null)
    {
        $request->validate([
            'name' => 'required:unique:methods,name,' . $id . ',id',
            'balance' => 'required|numeric'
        ]);
    }

    public function addBalance(Request $request)
    {
        try {
            $method = Method::find($request->method_id);
            if ($method) {
                $newBalance = new Method();
                $newBalance->name = $method->name;
                $newBalance->balance = $request->balance;
                $newBalance->save();
            }
            successAlert('Balance added successfully');
            return redirect()->route('payment_method.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }
}