<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Type;
use Brian2694\Toastr\Facades\Toastr;
use Yajra\DataTables\DataTables;
class TypeController extends Controller
{
    public function index(Request $request)
    {
        $collection = Type::latest('id')->paginate(10);
        return view('type.list', compact('collection'));
    }

    public function create()
    {
        return view('type.add');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:types,name'
        ]);

        try {
            $type = new Type();
            $type->name = $request->name;
            $type->save();
            successAlert('Type successfully created');
            return redirect()->route('type.index');
        }catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        $type = Type::find($id);
        return view('type.edit', compact('type'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|unique:types,name,'.$id.',id'
        ]);

        try {
            $type = Type::find($id);
            $type->name = $request->name;
            $type->save();
            successAlert('Type successfully updated');
            return redirect()->route('type.index');
        }catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function delete($id)
    {
        try {
            $type = Type::find($id);
            $type->delete();
            successAlert('Type successfully deleted');
            return redirect()->route('type.index');
        }catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }
}
