<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SetStoreId
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        // Logic to retrieve the store_id (you can modify this logic as per your need)
        $storeId = auth()->user()->store_id ?? null;
        $superAdminPanel = false;

        if (!empty($request->route()->action['as'])){
            $routeNames = explode('.', $request->route()->action['as']);
            if (is_array($routeNames) && $routeNames[0]  === 'admin') {
                $superAdminPanel = true;
            }
        }

        if (!$superAdminPanel){
            // Add the store_id to the request
            if ($storeId) {
                $request->attributes->set('store_id', $storeId);
            }
        }

        return $next($request);
    }
}
