<?php

namespace App\Models\hrm;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    public function designation(){
        return $this->belongsTo(Designation::class);
    }
    public function department(){
        return $this->belongsTo(Department::class);
    }

    public function getNameAttribute($value)
    {
        return "{$this->first_name} {$this->last_name}";
    }

}
