<?php


namespace App\Service;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class ProfitExcelExportService implements FromView
{

    protected $reports;
    protected $total_sale_balance;
    protected $total_profit_balance;
    protected $total_loss_balance;
    protected $balanceInhand;
    public function __construct($reports, $total_sale_balance, $total_profit_balance, $total_loss_balance, $balanceInhand
    )
    {
        $this->reports = $reports;
        $this->total_sale_balance = $total_sale_balance;
        $this->total_profit_balance = $total_profit_balance;
        $this->total_loss_balance = $total_loss_balance;
        $this->balanceInhand = $balanceInhand;
    }

    public function view(): View
    {
        return view('exports.profit_report', [
            'reports' => $this->reports,
            'total_sale_balance' => $this->total_sale_balance,
            'total_profit_balance' => $this->total_profit_balance,
            'total_loss_balance' => $this->total_loss_balance,
            'balanceInhand' => $this->balanceInhand
        ]);
    }
}