<?php


namespace App\Service;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class SalePurchaseExcelExportService implements FromView
{
    protected $reports;
    protected $total_sale_amount;
    protected $total_purchase_amount;
    protected $total_sale;
    protected $total_purchase;

    public function __construct($reports, $total_sale_amount, $total_purchase_amount, $total_sale, $total_purchase)
    {
        $this->reports = $reports;
        $this->total_sale_amount = $total_sale_amount;
        $this->total_purchase_amount = $total_purchase_amount;
        $this->total_sale = $total_sale;
        $this->total_purchase = $total_purchase;
    }

    public function view(): View
    {
        return view('exports.sale_purchase_report', [
            'reports' => $this->reports,
            'total_sale_amount' => $this->total_sale_amount,
            'total_purchase_amount' => $this->total_purchase_amount,
            'total_sale' => $this->total_sale,
            'total_purchase' => $this->total_purchase
        ]);
    }
}