@extends('layouts.backend')
@section('title', "Trail Balance")
@section('content')
<x-container title="Trail Balance" >
    <div class="text-end">
        <a href="javascript:" id="window-printer" onclick="return(window.print())" class="btn btn-sm btn-success mb-2">
            <i class="fa fa-print"></i>
            {{ translate('common.Print') }}
        </a>
    </div>
    <div class="table-responsive pt-0">
        <table class="table">
            <x-table.thead :headers="['Account','Debit','Credit']"></x-table.thead>
            <tbody>
            @foreach($collection as $account)
                @if($account->total_debits > 0 || $account->total_credits > 0)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $account->name }}</td>
                    <td>{{ $account->total_debits != 0 ? priceFormat($account->total_debits) : '-' }}</td>
                    <td>{{ $account->total_credits != 0 ? priceFormat($account->total_credits) : '-' }}</td>
                </tr>
                @endif
            @endforeach
            </tbody>
            <tfoot>
            <tr>
                <td></td>
                <td class="text-start"><h4 class="mb-0 text-dark fw-bold">{{ translate('common.Total') }}</h4></td>
                <td><h4 class="mb-0 text-dark fw-bold">{{ priceFormat($collection->sum('total_debits')) }}</h4></td>
                <td><h4 class="mb-0 text-dark fw-bold">{{ priceFormat($collection->sum('total_credits')) }}</h4></td>
            </tr>
            </tfoot>
        </table>
    </div>
</x-container>
@endsection