@extends('layouts.app')
@section('title', translate('common.invoice_reports'))
@section('custom-css')
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css"/>
@endsection
@if (request()->get('from') && request()->get('to'))
    @php
        $dto = request()->get('to');
        $dfrom = request()->get('from');
    @endphp
@else
    @php
        $dfrom = date('Y-m-d', strtotime('-7 day', time()));
        $dto = date('Y-m-d');
    @endphp
@endif



@php
    $datelist = list_days($dfrom, $dto);

@endphp
@php
    $setting = Auth::user()->shop;
@endphp
@section('content')
    <x-container title="Sales & Purchase Reports">
        <div class="row justify-content-center">
            <div class="col-lg-3  my-2">
                <div class="bg-danger p-2 text-center" role="alert">
                    <h4 class="text-light">{{ $total_sale }}</h4>
                    <h5 class="text-light"> Total Sale Invoice</h5>
                </div>
            </div>
            <div class="col-lg-3  my-2">
                <div class="bg-primary  p-2 text-center" role="alert">
                    <h4 class="text-light">{{ priceFormat($total_sale_amount) }} </h4>
                    <h5 class="text-light">Total Sale Amount <br> <span class=""></span></h5>
                </div>
            </div>
            <div class="col-lg-3  my-2">
                <div class="bg-info p-2 text-center" role="alert">
                    <h4 class="text-light">{{ $total_purchase }} </h4>
                    <h5 class="text-light">Total Purchase Invoice<br> <span class=""></span></h5>
                </div>
            </div>
            <div class="col-lg-3 my-2">
                <div class="bg-success  p-2 text-center" role="alert">
                    <h4 class="text-light"> {{ priceFormat($total_purchase_amount) }}</h4>
                    <h5 class="text-light">Total Purchase Amount</h5>
                </div>
            </div>
        </div>
        <div class="row justify-content-between align-items-center">
            <div class="col-lg-6">
                <form method="get" class="mb-1">
                    <div class="col-md-5 user_role">
                        <label class="form-label" for="UserRole">{{ translate('common.from_date') }}</label>
                        <input value="@php echo $dfrom @endphp  - @php echo $dto @endphp" type="text"
                               name="date" id="reportrange"
                               class="form-control invoice-edit-input date-picker flatpickr-input">
                    </div>
                </form>
            </div>

            <div class="col-lg-6 text-end">
                <x-table.export-option/>
            </div>
        </div>

        <div class="table-responsive">
            <table class="user-list-table table table-bordered border-dark">
                <thead class="table-light">
                <tr>
                    <th>{{ translate('common.date') }}</th>
                    <th>Total Sales Inv.</th>
                    <th>{{ translate('common.Sales Price') }}</th>
                    <th>{{ translate('common.Total Amount') }}</th>
                    <th>{{ translate('common.Total Purchase Inv') }}</th>
                    <th>{{ translate('common.Purchase Price') }}</th>
                    <th>{{ translate('common.Paid To Supplier') }}</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($reports as $report)
                    <tr>
                        <th width="15%">{{ date('d M Y', strtotime($report['date'])) }}</th>
                        <th>{{ $report['total_sele'] }}</th>
                        <th>{{ priceFormat($report['total_sale_price']) }}</th>
                        <th>{{ priceFormat($report['total_sale_amount']) }}</th>
                        <th>{{ $report['total_purchase'] }}</th>
                        <th>{{ priceFormat($report['total_purchase_price']) }}</th>
                        <th>{{ priceFormat($report['total_purchase_amount']) }}</th>

                    </tr>
                @endforeach


                </tbody>


            </table>
        </div>
    </x-container>
@endsection

@section('custom-js')
    <script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>
    <script type = "text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js" ></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    @php
        $date = date('Y-m-d', strtotime('-7 day', time()));
    @endphp
    <!-- END: Page Vendor JS-->



    <script type="text/javascript">
        $(function () {


            var start = moment().subtract(29, 'days');
            var end = moment();

            var d = new Date();

            var up = function (start, end) {

                window.location.href = "?from=" + start + "&to=" + end;
            }

            $('input[name="date"]').daterangepicker({
                startDate: start,
                endDate: end,
                format: 'YYYY-MM-DD',
                timePicker: false,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')]
                }
            }, function (start, end, label) {
                var start2 = start.format("YYYY-MM-DD");
                var end2 = end.format("YYYY-MM-DD");

                window.start = start2;
                window.end = end2;

                up(start2, end2);
            });
        });
    </script>
@endsection
