@extends('layouts.app')
@section('title', 'Sale List')
@section('content')
    <x-container title="Sale List" >
        <div class="row justify-content-between mb-1">
            <div class="col-lg-2">
                <select name="paginate" onchange="changePagination(this.value)" id=""
                        class="form-select">
                    <option value="10" selected>{{ translate('common.Show') }}</option>
                    <option value="10" @if (request('paginate') == 10) selected @endif>
                        {{ translate('common.10') }}</option>
                    <option value="20" @if (request('paginate') == 20) selected @endif>
                        {{ translate('common.20') }}</option>
                    <option value="50" @if (request('paginate') == 50) selected @endif>
                        {{ translate('common.50') }}</option>
                    <option value="100" @if (request('paginate') == 100) selected @endif>
                        {{ translate('common.100') }}</option>
                    <option value="200" @if (request('paginate') == 200) selected @endif>
                        {{ translate('common.200') }}</option>
                </select>
            </div>
            <div class="col-lg-6">
                <form action="" class="row">
                    <div class="col-lg-5">
                        <input type="date" value="{{ request('from_date') }}" class="form-control"
                               name="from_date">
                    </div>
                    <div class="col-lg-5">
                        <input type="date" value="{{ request('to_date') }}" class="form-control"
                               name="to_date">
                    </div>
                    <div class="col-lg-2">
                        <button type="submit" class="btn btn-primary">
                            Filter
                        </button>
                    </div>
                </form>
            </div>
            <div class="col-lg-4">
                <form onsubmit="searchKeyword(e)">
                    <input type="text" id="search-keyword" name="keywords"
                           value="{{ request('keywords') ?? '' }}"
                           placeholder="{{ translate('common.Search by invoice') }}" class="form-control">
                </form>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-bordered">
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.date') }}</th>
                    <th>{{ __('Invoice ID') }}</th>
                    <th>{{ translate('common.customer') }}</th>
                    <th>{{ translate('common.Quantity') }}</th>
                    <th>{{ translate('Subtotal+Vat') }}</th>
                    <th>{{ translate('Discount') }}</th>
                    <th>{{ translate('common.total') }}</th>
                    <th>{{ translate('common.due') }}</th>
                    <th>{{ translate('common.option') }}</th>
                </tr>
                <tbody>
                @forelse($invoices as $invoice)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $invoice->date }}</td>
                        <td>{{ $invoice->inv_id }}</td>
                        <td>{{ $invoice->customer ? $invoice->customer->name : 'Walk In Customer' }}</td>
                        <td class="text-center">{{ $invoice->qty }}</td>
                        <td class="text-center">{{ number_format($invoice->total_price, 2) }}</td>
                        <td class="text-center">{{ number_format($invoice->discount, 2) }}</td>
                        <td class="text-center">{{ number_format($invoice->paid_amount, 2) }}</td>
                        <td class="text-center">{{ number_format($invoice->due_price, 2) }}</td>
                        <td>
                            @if ($invoice->qty > 0)
                                <a href="{{ route('invoice.print', $invoice->id) }}"
                                   class="btn btn-success btn-circle text-white btn-sm"><i class="fa fa-eye"></i>
                                </a>
                                <a href="{{ route('returned', $invoice->id) }}"
                                   class="btn btn-warning btn-circle text-white btn-sm"><i class="fa fa-undo"></i>
                                </a>
                            @else
                                <a href="{{ route('invoice.print', $invoice->id) }}"
                                   class="btn btn-success btn-circle text-white btn-sm"><i class="fa fa-eye"></i>
                                </a>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="10" class="text-center">
                            <h4 class="py-4">{{ translate('common.No date found') }}!</h4>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="pagination mt-2">
            {!! $invoices->links() !!}
        </div>
    </x-container>
@endsection

@section('custom-js')
    <script>
        function changePagination(paginate) {
            var nurl = new URL('{{ route('invoice.reports') }}');
            nurl.searchParams.set('paginate', paginate);
            location.href = nurl;
        }


        function searchKeyword(e) {
            e.preventDefault();
            let keyword = $('#search-keyword')
            var nurl = new URL('{{ route('invoice.reports') }}');
            nurl.searchParams.set('keywords', keyword);
            location.href = nurl;
        }
    </script>
@endsection
