@extends('layouts.app')
@section('title', translate('common.Returned Medicine'))
@section('content')
    @php
        $i = 0;
        $medicines = json_decode($inv->medicines, true);
        $count = count($medicines);
    @endphp
    <x-container title="Returned Medicine" buttonTitle="Back" buttonRoute="{{ route('invoice.reports') }}">
        <form class="form" method="POST" action="{{ route('returned', $inv->id) }}">
            @csrf
            <div class="row">
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="first-name-column">{{ translate('Medicine Name') }}</label>
                        <select name="medicine" class="form-select">
                            @foreach ($medicines as $medicine)
                                @php
                                    $amount = $medicine['price'] * $medicine['quantity'];
                                @endphp
                                <option
                                        value="{{ $medicine['batch_id'] }}_{{ $medicine['quantity'] }}_{{ $amount }}">
                                    {{ $medicine['name'] }} ({{ $medicine['quantity'] }} PC) -
                                    {{ priceFormat($amount) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="first-name-column">{{ translate('Quantity') }}</label>
                        <input type="number" name="qty" required min="1"
                               class="form-control">
                        @error('qty')
                        <span class="text-danger">Quantity is required!</span>
                        @enderror
                    </div>
                </div>

                <div class="col-12">
                    <button type="submit"
                            class="btn btn-primary me-1 waves-effect waves-float waves-light">{{ translate('common.submit') }}</button>
                    <button type="reset"
                            class="btn btn-outline-secondary waves-effect">{{ translate('common.reset') }}</button>
                </div>
            </div>
        </form>
    </x-container>
@endsection
