@extends('layouts.app')
@section('title', __('Return History'))

@section('content')
    <x-container title="Sale Return History">
        <table class="table">
            <thead>
            <tr>
                <th>{{ translate('common.sn') }}</th>
                <th>{{ translate('common.invoice') }}</th>
                <th>{{ translate('common.date') }}</th>
                <th>{{ translate('common.Qty') }}</th>
                <th>{{ translate('common.amount') }}</th>
                <th>{{ translate('common.action') }}</th>
            </tr>
            </thead>
            <tbody>
            @forelse($collection as $key => $row)
            <tr>
                <td>{{ $key +1 }}</td>
                <td>{{ $row->inv_id }}</td>
                <td>{{ $row->date }}</td>
                <td>{{ $row->quantity }}</td>
                <td>{{ $row->amount }}</td>
                <td>
                    <a href="{{ route('invoice.return_invoice.view', $row->id) }}"
                       class="btn btn-success text-white btn-sm">
                        <i class="fa fa-eye"></i> {{ translate('common.Invoice') }}
                    </a>
                </td>
            </tr>
            @empty
                <tr>
                    <td colspan="4"></td>
                </tr>
                @endforelse
            </tbody>
        </table>
        <div class="pagination">
            {!! $collection->links() !!}
        </div>
    </x-container>
@endsection
