@extends('layouts.app')
@section('title', translate('common.leaf'))
@section('content')
    <x-container title="leaf" buttonTitle="Leaf add" buttonRoute="{{ route('leaf.create') }}">
        <div class="table-responsive">
            <table class="table">
                <thead>
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.leaf_type') }}</th>
                    <th>{{ translate('common.qty_box') }}</th>
                    <th>{{ translate('common.option') }}</th>
                </tr>
                </thead>
                <tbody>
                @forelse($collection as $key => $row)
                <tr>
                    <td>{{ $key +1 }}</td>
                    <td>{{ $row->name }}</td>
                    <td>{{ $row->amount }}</td>
                    <td class="d-flex gap-1">
                        <x-action.edit  route="{{ route('leaf.edit', $row->id) }}"></x-action.edit>
                        <x-action.delete route="{{ route('leaf.delete', $row->id) }}"></x-action.delete>
                    </td>
                </tr>
                @empty
                    <tr>
                        <td colspan="4"><h4 class="py-5">{{ translate('common.No Data Found') }}</h4></td>
                    </tr>
                @endforelse
                </tbody>
            </table>
            <div class="pagination">
                {!! $collection->links() !!}
            </div>
        </div>
    </x-container>
@endsection
