@extends('layouts.app')
@section('title', translate('common.payment_method'))
@section('content')
    <x-container title="payment method" buttonRoute="{{ route('payment_method.create') }}" buttonTitle="Add New">
        <div class="table-responsive">
            <table class="table">
                <thead>
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.name') }}</th>
                    <th>{{ translate('common.balance') }}</th>
                    <th>{{ translate('common.option') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ priceFormat($row->total_balance) }}</td>
                        <td class="d-flex gap-1">
                            <button type="button" class="edit-button btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#addBalanceFor{{ $row->id }}">
                                <i class="fa fa-plus"></i>
                            </button>
{{--                            <x-action.edit  route="{{ route('payment_method.edit', $row->id) }}"></x-action.edit>--}}
{{--                            <x-action.delete route="{{ route('payment_method.delete', $row->id) }}"></x-action.delete>--}}
                        </td>
                    </tr>
                    <div class="modal fade" data-bs-backdrop="static" id="addBalanceFor{{ $row->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5">{{ translate('common.Add Balance') }}</h1>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form action="{{ route('payment_method.add_balance') }}" method="post">
                                        @csrf
                                        <input type="hidden" name="method_id" value="{{ $row->id }}">
                                        <x-form.input type="number" col="col-lg-12" name="balance" label="Amount" ></x-form.input>
                                        <div class="col-lg-12 text-end">
                                            <button type="submit" class="btn btn-primary">{{ translate('common.Submit') }}</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

                <tr>
                    <td></td>
                    <td class="text-end bg-warning fw-bold">{{ translate('Total Balance ') }}</td>
                    <td><strong>{{ priceFormat($total_balance) }}</strong></td>
                </tr>
                </tbody>
            </table>

            <h3 class="mt-2">{{ translate('Added Balance History') }}</h3>
            <table class="table">
                <thead>
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.name') }}</th>
                    <th>{{ translate('common.balance') }}</th>
                    <th>{{ translate('common.created at') }}</th>
                    <th>{{ translate('common.updated at') }}</th>
                    <th>{{ translate('common.option') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($history as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ priceFormat($row->balance) }}</td>
                        <td>{{ $row->created_at }}</td>
                        <td>{{ $row->updated_at }}</td>
                        <td class="d-flex gap-1">
                            <x-action.edit  route="{{ route('payment_method.edit', $row->id) }}"></x-action.edit>
                            <x-action.delete route="{{ route('payment_method.delete', $row->id) }}"></x-action.delete>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <div class="pagination">
                {!! $history->links() !!}
            </div>
        </div>
    </x-container>
@endsection
