@extends('layouts.backend')
@section('title', "In Stock Medicines")
@section('content')
    <x-container title="In Stock Medicines">
        <div class="table-responsive pt-0">
            <form action="" class="row mb-2">
                <div class="col-lg-4">
                    <input type="text" value="{{ request('keyword') }}" placeholder="Enter keyword" name="keyword" class="form-control">
                </div>
                <div class="col-lg-4">
                    <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i></button>
                </div>
            </form>
            <table class="table">
                <x-table.thead :headers="['Medicine','Quantity']"></x-table.thead>
                <tbody>
                @foreach($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ @$row->name }}</td>
                        <td>{{ $row->total_qty }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
            <div class="pagination">
                {!! $collection->links() !!}
            </div>
        </div>
    </x-container>
@endsection