@extends('layouts.backend')
@section('title', "Low Stock Medicine")
@section('content')
    <x-container title="Low Stock Medicine">
        <div class="table-responsive pt-0">
            <form action="" class="row mb-2">
                <div class="col-lg-4">
                    <input type="text" value="{{ request('keyword') }}" placeholder="Enter keyword" name="keyword" class="form-control">
                </div>
                <div class="col-lg-4">
                    <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i></button>
                </div>
            </form>
            <table class="table">
                <x-table.thead :headers="['Medicine','Manufacturer','Quantity']"></x-table.thead>
                <tbody>
                @forelse($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ @$row->supplier->name }}</td>
                        <td>{{ @$row->total_quantity }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center">
                            <h4 class="py-5">{{ translate('common.Empty ):') }}</h4>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
            <div class="pagination">
                {!! $collection->links() !!}
            </div>
        </div>
    </x-container>
@endsection