@extends('layouts.app')
@section('title', translate('common.types'))

@section('content')
    <x-container title="types" buttonTitle="type add" buttonRoute="{{ route('type.create') }}">
        <table class="user-list-table table">
            <thead class="table-light">
            <tr>
                <th>{{ translate('common.sn') }}</th>
                <th>{{ translate('common.name') }}</th>
                <th>{{ translate('common.option') }}</th>
            </tr>
            </thead>
            <tbody>
            @forelse($collection as $key => $row)
                <tr>
                    <td>{{ $key +1 }}</td>
                    <td>{{ $row->name }}</td>
                    <td class="d-flex gap-1">
                        <x-action.edit  route="{{ route('type.edit', $row->id) }}"></x-action.edit>
                        <x-action.delete route="{{ route('type.delete', $row->id) }}"></x-action.delete>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="3" class="text-center">
                        <h4 class="py-5">{{ translate('common.No Data Found') }}</h4>
                    </td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </x-container>
@endsection
